# SpringBoot + MinIO + 阿里云OSS 文件存储系统

这是一个基于SpringBoot的文件存储系统，支持MinIO和阿里云OSS两种存储后端，提供分片上传、断点续传、秒传等高级功能。

## 功能特性

- ✅ 支持MinIO和阿里云OSS双存储后端
- ✅ 文件分片上传
- ✅ 断点续传
- ✅ 文件秒传
- ✅ 多种文件格式支持
- ✅ 文件元数据管理
- ✅ 高性能文件上传下载
- ✅ 完整的RESTful API接口

## 技术栈

- Spring Boot 2.7+
- MinIO Java SDK
- 阿里云OSS SDK
- MySQL / PostgreSQL
- JPA
- Maven

## 快速开始

### 1. 环境准备

确保已安装以下环境：

- JDK 8+
- Maven 3.6+
- MySQL / PostgreSQL
- MinIO服务
- 阿里云OSS账号（可选）

### 2. 配置文件

修改 `application.yml` 配置文件：

```yaml
storage:
  minio:
    endpoint: http://localhost:9000
    access-key: your-access-key
    secret-key: your-secret-key
    bucket-name: file-storage
  oss:
    endpoint: oss-cn-hangzhou.aliyuncs.com
    access-key-id: your-access-key-id
    access-key-secret: your-access-key-secret
    bucket-name: your-bucket-name

spring:
  datasource:
    url: jdbc:mysql://localhost:3306/file_storage?useUnicode=true&characterEncoding=utf8&useSSL=false
    username: root
    password: password
    driver-class-name: com.mysql.cj.jdbc.Driver
  jpa:
    hibernate:
      ddl-auto: update
    show-sql: true
```

### 3. 启动项目

```bash
mvn spring-boot:run
```

## API接口

### 文件上传

```
POST /api/file/init-upload     - 初始化分片上传
POST /api/file/upload-chunk    - 上传文件分片
POST /api/file/complete-upload/{uploadId} - 完成分片上传
GET  /api/file/check-chunk/{uploadId}/{chunkIndex} - 检查分片是否存在
GET  /api/file/uploaded-chunks/{uploadId} - 获取已上传分片列表
DELETE /api/file/cancel-upload/{uploadId} - 取消上传
GET  /api/file/download/{fileMd5} - 下载文件
GET  /api/file/info/{fileMd5} - 获取文件信息
```

## 架构设计

```
┌─────────────────┐    ┌─────────────────┐    ┌─────────────────┐
│   前端应用      │───▶│   Spring Boot   │───▶│   MinIO / OSS   │
│   (分片上传)    │    │   (业务逻辑)    │    │   (存储服务)    │
└─────────────────┘    └─────────────────┘    └─────────────────┘
                            │
                            ▼
                    ┌─────────────────┐
                    │   MySQL         │
                    │   (元数据存储)   │
                    └─────────────────┘
```

## 分片上传流程

1. 客户端计算文件MD5并请求初始化上传
2. 服务端返回上传ID和上传策略
3. 客户端按分片上传文件
4. 服务端合并分片并清理临时文件
5. 返回文件访问URL

## 断点续传实现

- 通过MD5验证文件唯一性
- 记录分片上传状态
- 支持中断后从断点继续上传

## 性能优化

- 分片大小：2-5MB
- 并发上传：支持多分片并行上传
- 缓存机制：使用Redis缓存上传状态
- CDN加速：结合CDN提升下载速度

## 安全措施

- 文件类型校验
- 文件大小限制
- 访问权限控制
- 防盗链策略
- HTTPS传输

## 扩展建议

- 集成图片压缩和格式转换
- 添加文件内容安全检测
- 实现文件生命周期管理
- 集成更多存储后端

## 贡献

欢迎提交Issue和PR，共同完善此项目。

## 许可证

MIT License