package com.example.filestorage.exception;

import com.example.filestorage.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    
    @ExceptionHandler(Exception.class)
    public BaseResponse<String> handleException(HttpServletRequest request, Exception e) {
        logger.error("系统异常: {}", e.getMessage(), e);
        return BaseResponse.error("系统异常: " + e.getMessage());
    }
    
    @ExceptionHandler(RuntimeException.class)
    public BaseResponse<String> handleRuntimeException(HttpServletRequest request, RuntimeException e) {
        logger.error("运行时异常: {}", e.getMessage(), e);
        return BaseResponse.error("运行时异常: " + e.getMessage());
    }
    
    @ExceptionHandler(IllegalArgumentException.class)
    public BaseResponse<String> handleIllegalArgumentException(HttpServletRequest request, IllegalArgumentException e) {
        logger.error("参数错误: {}", e.getMessage(), e);
        return BaseResponse.error("参数错误: " + e.getMessage());
    }
}