package com.example.filestorage.model;

import lombok.Data;

import java.util.List;

@Data
public class UploadResult {
    private boolean success;
    private String message;
    private String fileId;
    private String url;
    private List<String> missingChunks; // 用于断点续传

    public static UploadResult success(String fileId, String url) {
        UploadResult result = new UploadResult();
        result.setSuccess(true);
        result.setMessage("上传成功");
        result.setFileId(fileId);
        result.setUrl(url);
        return result;
    }

    public static UploadResult continueUpload(List<String> missingChunks) {
        UploadResult result = new UploadResult();
        result.setSuccess(true);
        result.setMessage("继续上传");
        result.setMissingChunks(missingChunks);
        return result;
    }

    public static UploadResult fail(String message) {
        UploadResult result = new UploadResult();
        result.setSuccess(false);
        result.setMessage(message);
        return result;
    }
}