package com.example.filestorage.repository;

import com.example.filestorage.entity.UploadChunk;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UploadChunkRepository extends JpaRepository<UploadChunk, Long> {
    List<UploadChunk> findByUploadId(String uploadId);
    
    boolean existsByUploadIdAndChunkIndex(String uploadId, Integer chunkIndex);
    
    @Query("SELECT uc.chunkIndex FROM UploadChunk uc WHERE uc.uploadId = :uploadId AND uc.uploaded = true ORDER BY uc.chunkIndex")
    List<Integer> findUploadedChunkIndexes(@Param("uploadId") String uploadId);
    
    void deleteByUploadId(String uploadId);
}