package com.example.filestorage.response;

import lombok.Data;

import java.util.List;

@Data
public class InitUploadResponse {
    private String uploadId;
    private String status; // NEW, EXISTING, CONTINUE
    private List<Integer> missingChunks; // 需要上传的分片索引
    private String message;

    public static InitUploadResponse newUpload(String uploadId) {
        InitUploadResponse response = new InitUploadResponse();
        response.setUploadId(uploadId);
        response.setStatus("NEW");
        response.setMessage("新上传任务");
        return response;
    }

    public static InitUploadResponse existingFile(String fileId, String url) {
        InitUploadResponse response = new InitUploadResponse();
        response.setStatus("EXISTING");
        response.setMessage("文件已存在");
        return response;
    }

    public static InitUploadResponse continueUpload(String uploadId, List<Integer> missingChunks) {
        InitUploadResponse response = new InitUploadResponse();
        response.setUploadId(uploadId);
        response.setStatus("CONTINUE");
        response.setMissingChunks(missingChunks);
        response.setMessage("继续上传");
        return response;
    }
}