package com.example.filestorage.service;

import com.example.filestorage.entity.FileMetadata;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;

public interface FileStorageService {
    /**
     * 上传文件
     * @param file 文件
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     * @return 文件元数据
     */
    FileMetadata uploadFile(MultipartFile file, String bucketName, String objectName);

    /**
     * 上传文件流
     * @param inputStream 文件流
     * @param size 文件大小
     * @param contentType 内容类型
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     * @return 文件元数据
     */
    FileMetadata uploadFile(InputStream inputStream, long size, String contentType, String bucketName, String objectName);

    /**
     * 下载文件
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     * @return 文件流
     */
    InputStream downloadFile(String bucketName, String objectName);

    /**
     * 删除文件
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     */
    void deleteFile(String bucketName, String objectName);

    /**
     * 检查文件是否存在
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     * @return 是否存在
     */
    boolean exists(String bucketName, String objectName);

    /**
     * 获取文件访问URL
     * @param bucketName 存储桶名称
     * @param objectName 对象名称
     * @return 访问URL
     */
    String getFileUrl(String bucketName, String objectName);
}