package com.example.filestorage.service;

import com.example.filestorage.entity.FileMetadata;
import com.example.filestorage.request.InitUploadRequest;
import com.example.filestorage.request.UploadChunkRequest;
import com.example.filestorage.response.InitUploadResponse;

public interface FileUploadService {
    /**
     * 初始化分片上传
     */
    InitUploadResponse initUpload(InitUploadRequest request);
    
    /**
     * 上传文件分片
     */
    void uploadChunk(UploadChunkRequest request);
    
    /**
     * 合并文件分片
     */
    FileMetadata completeUpload(String uploadId);
    
    /**
     * 检查文件分片是否存在（用于断点续传）
     */
    boolean checkChunkExists(String uploadId, int chunkIndex);
    
    /**
     * 获取已上传的分片列表（用于断点续传）
     */
    java.util.List<Integer> getUploadedChunks(String uploadId);
    
    /**
     * 取消上传
     */
    void cancelUpload(String uploadId);
}